/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: ExtendedMemoryDialog.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    Device Extended Memory Area Dialog class

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2011-12-08  Added extended memory dialog (MRAM)
    2006-07-04  initial version

**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file ExtendedMemoryDialog.h
///   Extended Memory Dialog class  
///////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"

class CExtendedMemoryDialog : public CBaseDialog
{
	DECLARE_DYNAMIC(CExtendedMemoryDialog)

public:
	CExtendedMemoryDialog(CWnd* pParent = NULL);   // standard constructor
	virtual ~CExtendedMemoryDialog();

// Dialog Data
	enum { IDD = IDD_EXTENDED_MEMORY };

  virtual void    OnUpdateDevice(CCifXDeviceBase* pcDevice);
  virtual void    ThreadFunction(void)  { }


protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
  void         UpdateUI(void);

  CCifXDeviceBase*  m_pcCurrentDevice;

  ULONG             m_ulRecvDataOffset;
  ULONG             m_ulRecvDataLen;

  BYTE*             m_pbWriteData;
  ULONG             m_ulWriteDataLen;
  ULONG             m_ulWriteDataOffset;

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetMemPtr();
  afx_msg void OnBnClickedBtnMemRead();
  afx_msg void OnBnClickedBtnMemWrite();
  afx_msg void OnEnKillfocusMemoryWriteoffset();
  afx_msg void OnEnKillfocusMemoryReadoffset();
  afx_msg void OnEnKillfocusMemoryReadlength();
  virtual BOOL OnInitDialog();
};
